CREATE OR REPLACE FUNCTION TCad.GetPathPart (in_dtid VARCHAR(30), in_group INT, in_adkrz VARCHAR(21) DEFAULT NULL)
RETURNS TEXT AS $$
 BEGIN
   IF in_adkrz IS NULL THEN in_adkrz := '#'; END IF;
   RETURN (SELECT pp_value
      FROM TCad.PathPart
      WHERE pp_dtid = in_dtid
      AND pp_group = in_group
      AND pp_adkrz = in_adkrz)::TEXT;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.GetPath (in_ak_nr VARCHAR(40), in_pd_doktype VARCHAR(30))
RETURNS VARCHAR AS $$
DECLARE praefix VARCHAR(3);
        project_no VARCHAR(100);
BEGIN
CASE
   WHEN TSystem.Settings__Get('KUNDE') = 'APUS' THEN
     CASE
        WHEN in_ak_nr LIKE '9009%' AND in_pd_doktype = 'P00.cad.model' THEN
       in_pd_doktype := 'P90.do.def.doc';
    WHEN in_ak_nr LIKE '9%' AND in_pd_doktype = 'P00.cad.model' THEN
       in_pd_doktype := 'P20.general.rep';
        ELSE
     END CASE;
     IF TCad.GetPathPart(in_pd_doktype, 1) = '33_ChangeManagement' THEN
        IF EXISTS (SELECT 1 FROM anl WHERE an_nr = in_ak_nr) THEN
            -- in_ak_nr ist eine Projektnummer
            project_no := in_ak_nr;
        ELSE
        -- in_ak_nr ist eine Artikelnummer und es muss die Projektnummer gesucht werden
        SELECT ak_such INTO project_no FROM art WHERE ak_nr = in_ak_nr;
        END IF;
        RETURN CONCAT(COALESCE(TSystem.Settings__Get('NX_Daten_Pfad'), E'S:\\00_Document_Database'),E'\\' , TCad.GetPathPart(in_pd_doktype, 1), E'\\',  project_no, '_', (SELECT REPLACE(an_bez, ' ', '') FROM anl WHERE an_nr = project_no), E'\\');
     ELSE
        RETURN CONCAT(COALESCE(TSystem.Settings__Get('NX_Daten_Pfad'), E'S:\\00_Document_Database'),E'\\' , TCad.GetPathPart(in_pd_doktype, 1), E'\\',  LEFT(in_ak_nr,6), '_', tcad.nx_ak_bez(in_ak_nr), E'\\');
     END IF;
   ELSE
     RETURN TSystem.Settings__Get('NX_Daten_Pfad');
   END CASE;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION tcad.nx_ak_bez(in_ak_nr VARCHAR)RETURNS VARCHAR AS $$
DECLARE bezshort VARCHAR(100);
BEGIN
   SELECT INTO bezshort ak_bez FROM art WHERE ak_nr = in_ak_nr;
   CASE
     WHEN TSystem.Settings__Get('KUNDE') = 'APUS' OR TSystem.Settings__Get('KUNDE') = 'TAI' THEN
        -- Clean name for characters Windows and NX can't handle
    bezshort := replace(bezshort, ' ', '');
    bezshort := replace(bezshort, '/', '_');
    bezshort := replace(bezshort, '²', '2');
    bezshort := replace(bezshort, '³', '3');
   END CASE;
   RETURN bezshort;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.GetFilePath (in_ak_nr VARCHAR(40), in_pd_doktype VARCHAR(30), in_fileext VARCHAR(10))
RETURNS VARCHAR AS $$
DECLARE praefix VARCHAR(3);
        file_name VARCHAR(200);
        adkrz VARCHAR(21);
BEGIN
CASE
   WHEN TSystem.Settings__Get('KUNDE') = 'APUS' THEN
      praefix := left(in_pd_doktype, 3);
      -- Clean file extention
      CASE
         WHEN position('.' in in_fileext) = 0 THEN
            in_fileext := '.'||in_fileext;
         ELSE
            in_fileext := in_fileext;
      END CASE;
      -- Determine customer by the assigned project (ak_such)
      SELECT an_kund
      INTO adkrz
      FROM anl
      LEFT JOIN art ON an_nr = ak_such
      WHERE ak_nr = in_ak_nr;

      CASE
        -- use customer file name
        WHEN (TCad.UseCustFileName(in_ak_nr)
              AND NOT TCad.UseCustFilePath(in_ak_nr)
              AND (in_pd_doktype = 'P00.cad.model'
                   OR in_pd_doktype = 'P02.single.drawing'
                   OR in_pd_doktype = 'P07.design.parts.list'
                   OR in_pd_doktype = 'P10.specification'))
        THEN
            file_name := CONCAT(TCad.GetPath(in_ak_nr, in_pd_doktype), TCad.GetCustFileName(in_ak_nr, in_pd_doktype, in_fileext, adkrz));
        -- use customer file name and customer file path
        WHEN (TCad.UseCustFilePath(in_ak_nr)
              AND (in_pd_doktype = 'P00.cad.model'
                   OR in_pd_doktype = 'P02.single.drawing'
                   OR in_pd_doktype = 'P07.design.parts.list'
                   OR in_pd_doktype = 'P10.specification'))
        THEN
            file_name := TCad.GetCustFilePath(in_ak_nr, in_pd_doktype, in_fileext, adkrz);
        -- use regular path
        ELSE
            file_name := CONCAT(TCad.GetPath(in_ak_nr, in_pd_doktype) , praefix, '-', in_ak_nr, '_', tcad.nx_ak_bez(in_ak_nr), in_fileext);
      END CASE;
      RETURN file_name;
   ELSE
      RETURN TSystem.Settings__Get('NX_Daten_Pfad');
   END CASE;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.UseCustFileName (in_ak_nr VARCHAR(40))
RETURNS BOOLEAN AS $$
BEGIN
   RETURN (SELECT
              trecnoparam.exists('Change.CustFileName',anl.dbrid, false)
           FROM anl
           LEFT JOIN art ON an_nr = ak_such
           WHERE ak_nr = in_ak_nr);
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.UseCustFilePath (in_ak_nr VARCHAR(40))
RETURNS BOOLEAN AS $$
BEGIN
   RETURN (SELECT
              trecnoparam.exists('Change.CustFilePath',anl.dbrid, false)
           FROM anl
           LEFT JOIN art ON an_nr = ak_such
           WHERE ak_nr = in_ak_nr);
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION tcad.nxnr_to_aknr(in_nxnr varchar(100))
RETURNS varchar(100) AS $$
DECLARE aknr VARCHAR(100);
BEGIN
   CASE
      WHEN EXISTS (SELECT 1 FROM art WHERE ak_nr = substring(in_nxnr, 5, 9)) THEN
         aknr := substring(in_nxnr, 5, 9);
      ELSE
         CASE
            WHEN EXISTS (SELECT 1 FROM art WHERE ak_zolp1b = in_nxnr) THEN
               SELECT ak_nr INTO aknr FROM art WHERE ak_zolp1b = in_nxnr;

            WHEN EXISTS (SELECT 1 FROM artzuo WHERE az_kunr = in_nxnr) THEN
               SELECT az_pronr INTO aknr FROM artzuo WHERE az_kunr = in_nxnr;
            --FIX für RS.AERO Projekt
            WHEN EXISTS (SELECT 1 FROM artzuo WHERE az_kunr = split_part(split_part(in_nxnr, '_', 1),'P00-',2)) THEN
               SELECT az_pronr INTO aknr FROM artzuo WHERE az_kunr = split_part(split_part(in_nxnr, '_', 1),'P00-',2);
            --FIX für AQUILA Projekt
            WHEN EXISTS (SELECT 1 FROM artzuo WHERE az_kunr = CONCAT(split_part(in_nxnr, '_', 1),'_',split_part(in_nxnr, '_', 2))) THEN
               SELECT az_pronr INTO aknr FROM artzuo WHERE az_kunr = CONCAT(split_part(in_nxnr, '_', 1),'_',split_part(in_nxnr, '_', 2));
            ELSE
               aknr := substring(in_nxnr, 5, 9);
         END CASE;
   END CASE;
   RETURN aknr;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION tcad.nxmgc_to_mgc_id(
    in_ak_nr VARCHAR(100),
    in_nxmgc VARCHAR(100))
  RETURNS integer AS $$
 DECLARE mgcode INTEGER;
 BEGIN
  CASE
    WHEN in_nxmgc = 'qm' THEN
    mgcode = 4;
    WHEN in_nxmgc = 'm' THEN
    mgcode = 3;
    WHEN in_nxmgc = 'ml' THEN
    mgcode = 20;
    WHEN in_nxmgc = 'kg' THEN
        mgcode = 2;
    ELSE
        mgcode = 1;
  END CASE;
  CASE
     WHEN (SELECT COUNT(m_id)>0 FROM artmgc WHERE m_ak_nr = in_ak_nr AND m_mgcode = mgcode) THEN
    RETURN m_id FROM artmgc WHERE m_ak_nr = in_ak_nr AND m_mgcode = mgcode;
     ELSE
    RETURN tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(in_ak_nr);
  END CASE;
  --RETURN COALESCE(m_id,8888) FROM artmgc WHERE m_ak_nr = in_ak_nr AND m_mgcode = mgcode;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.PartlistAllowed (
    in_ak_nr VARCHAR(250),
    in_pd_doktype VARCHAR(30))
    RETURNS INTEGER AS $$
DECLARE status VARCHAR(19);
 BEGIN
-- 0 für nein
-- 1 für ja, Positionsnummern egal
-- 2 für ja, strikte Positionsnummern
  SELECT INTO status TRecnoParam.GetEnum('art.status.cad', art.dbrid) as art_status_cad FROM art WHERE ak_nr ILIKE in_ak_nr;
--Abfrage CAD Status, Sync nur bei Eingecheckt und Ausgecheckt und nicht mehr bei P, C und A
  CASE
    WHEN in_pd_doktype = 'P00' AND status IN ('O', 'I') THEN
      RETURN 1;
    WHEN in_pd_doktype IN ('P02','P03', 'P04') AND status IN ('O', 'I')  THEN
      RETURN 2;
    ELSE
      RETURN 0;
  END CASE;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.resolveUsername(str VARCHAR) RETURNS VARCHAR AS $$
  DECLARE name VARCHAR;
  BEGIN
    IF str IS NULL THEN
        RETURN null;
    END IF;
    SELECT LEFT(ad_vorn,1)||'. '||ad_name INTO name FROM llv LEFT OUTER JOIN adk ON ad_krz=ll_ad_krz WHERE COALESCE(ll_db_usename,ll_minr::VARCHAR) = str;
    IF name IS NULL THEN
    SELECT LEFT(ad_vorn,1)||'. '||ad_name INTO name  FROM llv LEFT OUTER JOIN adk ON ad_krz=ll_ad_krz WHERE ll_minr::VARCHAR = str;
    END IF;
    IF name IS NULL THEN
        SELECT LEFT(ad_vorn,1)||'. '||ad_name INTO name  FROM adk WHERE ad_krz = str;
    END IF;
    name:=COALESCE(name, str);
    RETURN name;
  END $$ LANGUAGE plpgsql;

DROP FUNCTION IF EXISTS TCad.ResolveAttributes(character varying);

CREATE OR REPLACE FUNCTION TCad.ResolveAttributes(
    IN aknr VARCHAR,
    OUT SF_PART_OF_NO VARCHAR,
    OUT SF_PART_OF_TITLE VARCHAR,
    OUT SF_PREPARED VARCHAR,
    OUT SF_PREPARED_DATE DATE,
    OUT SF_CHECKED  VARCHAR,
    OUT SF_CHECKED_DATE DATE,
    OUT SF_APPROVED VARCHAR,
    OUT SF_APPROVED_DATE DATE,
    OUT FirstRevAkNr VARCHAR(30),
    OUT SF_FIRST_REV_NO VARCHAR(5),
    OUT SF_FIRST_REV_DATE DATE,
    OUT SF_FIRST_REV_DESC VARCHAR,
    OUT LastRevAkNr VARCHAR(30),
    OUT SF_LAST_REV_NO VARCHAR(5),
    OUT SF_LAST_REV_DATE DATE,
    OUT SF_LAST_REV_DESC VARCHAR,
    OUT CurrRevAkNr VARCHAR(30),
    OUT SF_CURRENT_REV_NO VARCHAR(5),
    OUT SF_CURRENT_REV_DATE DATE,
    OUT SF_CURRENT_REV_DESC VARCHAR,
    OUT SF_SAFETY_CLASS VARCHAR(10),
    OUT SF_DRAWING_REMARKS VARCHAR,
    OUT SF_CUST_NAME VARCHAR,
    OUT SF_CUST_ART_NO VARCHAR,
    OUT SF_CUST_ART_NAME VARCHAR,
    OUT SF_CUST_PART_REV VARCHAR,
    OUT SF_CUST_PART_OF_NO VARCHAR,
    OUT SF_CUST_PART_OF_TITLE VARCHAR
) RETURNS RECORD AS $$
  DECLARE count_lower_rev INTEGER;
          customer VARCHAR;
  BEGIN
  -- Bereich für Part_of
    CASE
     WHEN (SELECT COUNT(*)>1 FROM stv WHERE st_n = aknr AND (tartikel.art__artikelstatus__by__ak_nr(st_zn)).artstatus = 'G')
     THEN
        SF_PART_OF_NO := '';
        SF_PART_OF_TITLE := 'Multiple Use';
     ELSE
        SELECT
        tartikel.art__ak_nr__index(st_zn,False),
        ak_bez
        INTO SF_PART_OF_NO, SF_PART_OF_TITLE
        FROM stv
        JOIN art ON ak_nr = st_zn
            WHERE st_n = aknr
            AND (tartikel.art__artikelstatus__by__ak_nr(st_zn)).artstatus = 'G';
    END CASE;
  -- Bereich für Prepared
    SF_PREPARED := TCad.CadStatusName(aknr,'P');
    SF_PREPARED_DATE := TCad.CadStatusDate(aknr,'P');
  -- Bereich für Checked
    SF_CHECKED := TCad.CadStatusName(aknr,'C');
    SF_CHECKED_DATE := TCad.CadStatusDate(aknr,'C');
  -- Bereich für Checked
    SF_APPROVED := TCad.CadStatusName(aknr,'A');
    SF_APPROVED_DATE := TCad.CadStatusDate(aknr,'A');
  -- Anzahl der Revisionen kleiner aktuelle Revision
    SELECT count(ak_nr)
    INTO count_lower_rev
    FROM art
    WHERE ak_nr LIKE tartikel.art__ak_nr__index(aknr)
    AND tartikel.art__ak_nr__index__GetIndexStringFull(ak_nr) <= tartikel.art__ak_nr__index__GetIndexStringFull(aknr);
  -- Bereich für SF_FIRST_REV
    CASE
    -- Wenn es nur eine Revision gibt soll nur CURRENT_REV gefüllt sein
    WHEN count_lower_rev < 2
    THEN
       FirstRevAkNr := null;
       SF_FIRST_REV_NO  := null;
       SF_FIRST_REV_DATE := null;
    ELSE
      SELECT
        ak_nr,
        tartikel.art__ak_nr__index__GetIndexStringFull(ak_nr) AS rev
      INTO  FirstRevAkNr, SF_FIRST_REV_NO
      FROM art
      WHERE ak_nr LIKE tartikel.art__ak_nr__index(aknr)
      AND length(ak_nr) = length(aknr)
      ORDER BY ak_nr ASC
      LIMIT 1;
      SF_FIRST_REV_DATE := TCad.CadStatusDate(FirstRevAkNr,'P');
      SF_FIRST_REV_DESC := trecnoparam.getvarchar('art.cad.rev.desc',(SELECT dbrid FROM art WHERE ak_nr = FirstRevAkNr));
    END CASE;
-- Bereich für SF_LAST_REV
     CASE
        -- Wenn es nur eine Revision gibt soll nur First_Rev gefüllt sein
        WHEN count_lower_rev = 1
        THEN
           LastRevAkNr := null;
           SF_LAST_REV_NO  := null;
           SF_LAST_REV_DATE := null;
        ELSE
           SELECT
             ak_nr,
             tartikel.art__ak_nr__index__GetIndexStringFull(ak_nr) AS rev
           INTO  LastRevAkNr, SF_LAST_REV_NO
           FROM art
           WHERE ak_nr LIKE tartikel.art__ak_nr__index(aknr)
           AND tartikel.art__ak_nr__index__GetIndexStringFull(ak_nr) < tartikel.art__ak_nr__index__GetIndexStringFull(aknr)
           AND length(ak_nr) = length(aknr)
           ORDER BY ak_nr DESC
           LIMIT 1;
           SF_LAST_REV_DATE := TCad.CadStatusDate(LastRevAkNr,'P');
           SF_LAST_REV_DESC := trecnoparam.getvarchar('art.cad.rev.desc',(SELECT dbrid FROM art WHERE ak_nr = LastRevAkNr));
     END CASE;
-- Bereich für SF_CURRENT_REV
    CurrRevAkNr := aknr;
    SF_CURRENT_REV_NO  := tartikel.art__ak_nr__index__GetIndexStringFull(aknr);
    SF_CURRENT_REV_DATE := TCad.CadStatusDate(aknr,'P');
    SF_CURRENT_REV_DESC := trecnoparam.getvarchar('art.cad.rev.desc',(SELECT dbrid FROM art WHERE ak_nr = aknr));
-- Bereich für SF_SAFETY_CLASS
    SELECT
       ak_allg1
    INTO SF_SAFETY_CLASS
    FROM art
    WHERE ak_nr = aknr;
-- Bereich Kundendaten
    -- Kunden bestimmen
    SELECT az_prokrz
    INTO customer
    FROM artzuo
    WHERE az_pronr = aknr
    LIMIT 1;
    -- Kundendaten bestimmen
    SELECT
       COALESCE(ad_fa1, az_prokrz),
       TCad.GetCustArtNr(az_kunr, az_prokrz),
       TCad.GetCustArtRev(az_kunr, az_prokrz),
       COALESCE(az_bez, ak_bez)
    INTO  SF_CUST_NAME, SF_CUST_ART_NO, SF_CUST_PART_REV, SF_CUST_ART_NAME
    FROM artzuo
    LEFT JOIN adk ON ad_krz = az_prokrz
    LEFT JOIN art ON ak_nr = aknr
    WHERE az_pronr = aknr
    AND az_prokrz = customer;
    SELECT
       COALESCE(TCad.GetCustArtNr(az_kunr, az_prokrz),'Cust No. missing'),
       COALESCE(az_bez, ak_bez)
    INTO SF_CUST_PART_OF_NO, SF_CUST_PART_OF_TITLE
    FROM stv
    JOIN art ON ak_nr = st_zn
    JOIN artzuo ON ak_nr = az_pronr
    WHERE st_n = aknr
    AND az_prokrz = customer
    AND (tartikel.art__artikelstatus__by__ak_nr(st_zn)).artstatus = 'G';
END $$ LANGUAGE plpgsql STABLE STRICT;

CREATE OR REPLACE FUNCTION TCad.CadStatusDate(
    in_ak_nr VARCHAR,
    in_cad_event VARCHAR(10)
 ) RETURNS date AS $$
 BEGIN
   CASE
   WHEN in_cad_event = 'P'
   THEN
      CASE
      WHEN (SELECT COUNT(*) > 0 FROM artlog WHERE akl_aknr = in_ak_nr AND akl_category = 'art.status.cad' AND akl_cad_event_new = in_cad_event)
      THEN
         RETURN insert_date
         FROM artlog
         WHERE akl_aknr = in_ak_nr
         AND akl_category = 'art.status.cad'
         AND akl_cad_event_new = in_cad_event;
      ELSE
         RETURN today();
      END CASE;
   ELSE
      RETURN insert_date
      FROM artlog
      WHERE akl_aknr = in_ak_nr
      AND akl_category = 'art.status.cad'
      AND akl_cad_event_new = in_cad_event;
   END CASE;
 END $$ LANGUAGE plpgsql STABLE STRICT;

CREATE OR REPLACE FUNCTION TCad.CadStatusName(
    in_ak_nr VARCHAR,
    in_cad_event VARCHAR(10)
 ) RETURNS VARCHAR AS $$
 BEGIN
   RETURN insert_by
   FROM artlog
   WHERE akl_aknr = in_ak_nr
   AND akl_category = 'art.status.cad'
   AND akl_cad_event_new = in_cad_event;
 END $$ LANGUAGE plpgsql STABLE STRICT;

CREATE OR REPLACE FUNCTION TCad.CAD_Sync(item VARCHAR(100), isCheckOut BOOLEAN DEFAULT NULL, isCheckIn BOOLEAN DEFAULT NULL, isPrepared BOOLEAN DEFAULT NULL, isChecked BOOLEAN DEFAULT NULL, isApproved BOOLEAN DEFAULT NULL) RETURNS BOOLEAN AS $$
 BEGIN
  IF NOT EXISTS(
    SELECT
      true
    FROM
      TCad.CADSyncItems
    WHERE
      (csi_item = (Upper(item))))
  THEN
    INSERT INTO TCad.CADSyncItems
      (csi_item)
    VALUES (Upper(item));
  END IF;

  RETURN(SELECT
    csi_autosync
  FROM
    TCad.CADSyncItems
  WHERE
    (Upper(item) LIKE csi_item) AND
    ((csi_whencheckout = isCheckOut) OR
     (csi_whencheckin  = isCheckIn) OR
     (csi_whenprepared = isPrepared) OR
     (csi_whenchecked = isChecked) OR
     (csi_whenapproved = isApproved)
    ));
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION tcad.blockedfile(IN in_ak_nr character varying)
  RETURNS TABLE(file VARCHAR, doctype VARCHAR, shortname VARCHAR, name VARCHAR, date DATE) AS $$
  BEGIN
    RETURN QUERY
    SELECT
      pd_path, pd_doktype, pdr_blocked_by, nameAufloesen(pdr_blocked_by) AS pdr_blocked_by_name, pdr_blocked_date::DATE
    FROM picndoku_revision
    JOIN picndoku ON pd_id = (SELECT pd_id FROM picndoku
                    WHERE pd_id = pdr_blocked_pd_id OR pd_revision_id = pdr_revision_id
                    ORDER BY pd_id = pdr_blocked_pd_id DESC, pd_id DESC LIMIT 1)
    LEFT JOIN dokutypes ON dt_id = pd_doktype
    JOIN art on art.dbrid = pd_dbrid
    WHERE pd_tablename = 'art'
    AND ak_nr = in_ak_nr
    AND pd_doktype IN('P00.cad.model', 'P02.single.drawing', 'P03.lamination.plan', 'P04.assembly.drawing')
    AND pdr_blocked_date IS NOT NULL
    AND NOT pd_deletable; -- Gelöschte Dokumente ausschließen
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.isstatuschangeallowed(
    IN in_aknr VARCHAR,
    IN statusold VARCHAR DEFAULT 'N'::VARCHAR,
    IN statusnew VARCHAR DEFAULT 'N'::VARCHAR,
    OUT allowed BOOLEAN,
    OUT textnr INTEGER)
  RETURNS record AS $$
  DECLARE
     roleP VARCHAR;
     roleC VARCHAR;
     roleA VARCHAR;
  BEGIN
    textnr := NULL;
    CASE
    WHEN TSystem.Settings__Get('KUNDE') = 'APUS' THEN
        -- Fallunterscheidung DO, PO, CO
        CASE
          WHEN LEFT(in_aknr,2) = '13' AND LENGTH(in_aknr::TEXT) > 9 THEN
              -- PO
              BEGIN
                roleP := 'HoQM';
                roleC := 'HoP';
                roleA := 'HoQM';
              END;
          WHEN LEFT(in_aknr,3) = '119' AND LENGTH(in_aknr::TEXT) > 9 THEN
              -- CO
              BEGIN
                roleP := 'QMR';
                roleC := 'CEO';
                roleA := 'QMR';
              END;
          ELSE
              -- DO und anderes
              BEGIN
                roleP := 'DE';
                roleC := 'CVE';
                roleA := 'HoA';
              END;
        END CASE;
        -- Fallunterscheidung P, C, A
        CASE
          -- Prepared
          WHEN statusnew = 'P' THEN
              allowed := TCad.UserHasRole(roleP);
              CASE WHEN allowed = false THEN
                  textnr := 27013;
              ELSE
                  -- Check Wiedervorlage erstellen
                  PERFORM TCad.CreateReminder(roleC,in_aknr);
              END CASE;
          -- Checked
          WHEN statusnew = 'C' THEN
              allowed := TCad.UserHasRole(roleC);
              CASE WHEN allowed = false THEN
                  textnr := 27014;
              ELSE
                  -- Check Wiedervorlagen löschen
                  PERFORM TCad.DeleteReminder(roleC,in_aknr);
                  -- Approved Wiedervorlagen erstellen
                  /*SELECT TCad.CreateReminder(roleA,in_aknr);*/
              END CASE;
          -- Approved
          WHEN statusnew = 'A' THEN
              allowed := TCad.UserHasRole(roleA);
              CASE WHEN allowed = false THEN
                  textnr := 27015;
              ELSE
                  -- Approve Wiedervorlagen löschen
                  PERFORM TCad.DeleteReminder(roleA,in_aknr);
              END CASE;
          -- Status zurücksetzen
          WHEN statusnew IS NULL THEN
              -- Check Wiedervorlagen löschen
              PERFORM TCad.DeleteReminder(roleC,in_aknr);
              -- Approve Wiedervorlagen löschen
              PERFORM TCad.DeleteReminder(roleA,in_aknr);
              allowed := TRUE;
          ELSE
              allowed := TRUE;
        END CASE;
    ELSE
        allowed := TRUE;
    END CASE;
END $$ LANGUAGE plpgsql;

-- Ergänzung um Unterfunktionen
CREATE OR REPLACE FUNCTION TCad.UserHasRole (
   in_role VARCHAR(200))
RETURNS BOOLEAN AS $$
BEGIN
  RETURN EXISTS(SELECT *
  FROM anfmitarbzu
  JOIN mitarbrollen ON amz_mar_id = mar_id
  WHERE amz_minr = current_user_minr()
  AND mar_descr = in_role);
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.CreateReminder (
   in_role VARCHAR(200),
   in_aknr VARCHAR(40))
RETURNS void AS $$
DECLARE
   attr_name VARCHAR(200);
BEGIN
    CASE in_role
       WHEN 'DE' THEN attr_name := 'Change.DE';
       WHEN 'CVE' THEN attr_name := 'Change.CVE';
       ELSE attr_name = '1';
    END CASE;

    IF (SELECT
        CASE WHEN ak_such IS NULL
        THEN FALSE
        ELSE (SELECT trecnoparam.getvalue(attr_name, anl.dbrid) IS NOT NULL FROM anl WHERE an_nr = ak_such)
        END
        FROM art
        WHERE ak_nr = in_aknr)
    THEN
        -- Es gibt einen zugewiesenen Mitarbeiter im Projekt (geht nur für Changes)
        INSERT INTO recnocomments
        (rc_allg1,
        rc_tablename,
        rc_dbrid,
        rc_betreff,
        rc_text,
        rc_wvod,
        rc_wvod_params,
        rc_user)
        SELECT
        'Artikelverwaltung  ~  '||ak_nr||'            ',
        'art',
        art.dbrid,
        CONCAT('[',in_role,'] ', COALESCE(an_nr, ak_nr),' - ',COALESCE(an_bez,ak_bez)),
        ak_bez,
        today(),
        'Modul=TFormArtikel'||chr(10)||'ControlEd='||ak_nr||chr(10),
        trecnoparam.getvalue(attr_name, anl.dbrid)
        FROM art
        JOIN anl ON ak_such = an_nr
        WHERE ak_nr = in_aknr;
    ELSE
        -- Es gibt keine Zugewiesene Person --> Wiedervorlage an alle mit der Rolle
        INSERT INTO recnocomments
        (rc_allg1,
        rc_tablename,
        rc_dbrid,
        rc_betreff,
        rc_text,
        rc_wvod,
        rc_wvod_params,
        rc_user)
        SELECT
        'Artikelverwaltung  ~  '||ak_nr||'            ',
        'art',
        art.dbrid,
        CONCAT('[',in_role,'] ', COALESCE(an_nr, ak_nr),' - ',COALESCE(an_bez,ak_bez)),
        ak_bez,
        today(),
        'Modul=TFormArtikel'||chr(10)||'ControlEd='||ak_nr||chr(10),
        ll_ad_krz
        FROM llv
        JOIN art ON TRUE
        LEFT JOIN anl ON ak_such = an_nr
        JOIN anfmitarbzu ON ll_minr = amz_minr
        JOIN mitarbrollen ON amz_mar_id = mar_id
        WHERE mar_descr = in_role
        AND ak_nr = in_aknr;
    END IF;
     RETURN;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.DeleteReminder (
   in_role VARCHAR(200),
   in_aknr VARCHAR(40))
RETURNS void AS $$
BEGIN
   DELETE FROM recnocomments
   WHERE rc_tablename = 'art'
   AND rc_betreff LIKE CONCAT('[',in_role,']%')
   AND rc_dbrid = (SELECT dbrid FROM art WHERE ak_nr = in_aknr);
   RETURN;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.GetCustFileName (in_ak_nr VARCHAR(40), in_pd_doktype VARCHAR(30), in_fileext VARCHAR(10), in_adkrz VARCHAR(21) DEFAULT NULL)
RETURNS VARCHAR AS $$
DECLARE praefix VARCHAR(3);
        file_name VARCHAR(200);
        cust_art_no VARCHAR(50);
        cust_art_rev VARCHAR(5);
        cust_art_name VARCHAR(100);
        custfn VARCHAR(40);
        custpfx VARCHAR(40);
        custpfxwc VARCHAR(40);
BEGIN
    -- Clean file extention
    IF position('.' in in_fileext) = 0 THEN
        in_fileext := '.'||in_fileext;
    END IF;
    -- Determine Customer if not assigned
    IF in_adkrz IS NULL THEN in_adkrz := (SELECT an_kund FROM anl LEFT JOIN art ON an_nr = ak_such WHERE ak_nr = in_ak_nr); END IF;
    -- Determine customer filename
    CASE
       WHEN (in_pd_doktype = 'P00.cad.model'
             OR in_pd_doktype = 'P02.single.drawing'
             OR in_pd_doktype = 'P07.design.parts.list'
             OR in_pd_doktype = 'P10.specification')
      THEN
      -- determine customer number and part designation
      SELECT
         az_kunr,
         az_bez
      INTO  cust_art_no, cust_art_name
      FROM artzuo
      WHERE az_pronr = in_ak_nr
      AND az_prokrz = in_adkrz
      LIMIT 1;
      -- remove spaces from part designation
      cust_art_name := replace(cust_art_name, ' ', '');
      -- determine customer filename depending on prefix
      CASE
         WHEN in_pd_doktype = 'P00.cad.model' THEN
             custfn := 'Cust.fnCAD';
             custpfx := 'Cust.pfxCAD';
             custpfxwc := '[pfxCAD]';
         WHEN in_pd_doktype = 'P02.single.drawing' THEN
             custfn := 'Cust.fndwg';
             custpfx := 'Cust.pfxdwg';
             custpfxwc := '[pfxdwg]';
         WHEN in_pd_doktype = 'P07.design.parts.list' THEN
             custfn := 'Cust.fnbom';
             custpfx := 'Cust.pfxbom';
             custpfxwc := '[pfxbom]';
         WHEN in_pd_doktype = 'P10.specification' THEN
             custfn := 'Cust.fnspc';
             custpfx := 'Cust.pfxspc';
             custpfxwc := '[pfxspc]';
      END CASE;

      file_name := (SELECT trecnoparam.getvarchar(custfn, adk.dbrid)
                FROM adk
                WHERE ad_krz = in_adkrz);

      praefix := (SELECT trecnoparam.getvarchar(custpfx, art.dbrid)
              FROM art
              WHERE ak_nr = in_ak_nr);

      cust_art_rev :=  TCad.GetCustArtRev(cust_art_no,in_adkrz);
      cust_art_no := TCad.GetCustArtNr(cust_art_no,in_adkrz);

      --Präfix ersetzen
      file_name := replace(file_name, custpfxwc, COALESCE(praefix,'Set Präfix in Article'));
      file_name := replace(file_name, '[custdesc]', COALESCE(cust_art_name,tcad.nx_ak_bez(in_ak_nr)));
      file_name := replace(file_name, '[custartnr]', COALESCE(cust_art_no,''));
      file_name := replace(file_name, '[rev]', COALESCE(cust_art_rev,''));
      file_name := CONCAT(file_name, in_fileext);
      RETURN file_name;
    ELSE
      RETURN NULL;
    END CASE;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION tcad.getcustfilepath(
    in_ak_nr VARCHAR,
    in_pd_doktype VARCHAR,
    in_fileext VARCHAR,
    in_adkrz VARCHAR DEFAULT NULL::VARCHAR)
RETURNS VARCHAR AS $$
DECLARE praefix VARCHAR(3);
        file_name VARCHAR(200);
        file_path VARCHAR(400);
        cust_art_no VARCHAR(50);
        cust_art_rev VARCHAR(5);
        cust_art_name VARCHAR(100);
        ata_chapter VARCHAR(40);
BEGIN
      -- Determine Customer if not assigned
      IF in_adkrz IS NULL THEN in_adkrz := (SELECT an_kund FROM anl LEFT JOIN art ON an_nr = ak_such WHERE ak_nr = in_ak_nr); END IF;
      -- Determine customer filename
      CASE
         WHEN in_pd_doktype IN ('P00.cad.model', 'P01.geometry.drawing', 'P02.single.drawing', 'P03.lamination.plan',
                                'P04.assembly.drawing', 'P05.exploded.drawing', 'P06.wiring.diagram', 'P07.design.parts.list' ,
                                'P08.elec.comp.list', 'P09.wiring.list', 'P10.specification', 'P11.block.diagram',
                                'P12.work.qual.cplan', 'P13.electrical.harness.plan', 'P14.production.cad.export')
         THEN
              -- determine customer number and part designation
              SELECT
                  az_kunr,
                  az_bez
              INTO  cust_art_no, cust_art_name
              FROM artzuo
              WHERE az_pronr = in_ak_nr
              AND az_prokrz = in_adkrz
              LIMIT 1;
              -- remove spaces from part designation
              cust_art_name := replace(cust_art_name, ' ', '');
              -- get data
              cust_art_rev :=  TCad.GetCustArtRev(in_custaknr => cust_art_no, in_adkrz => in_adkrz);
              cust_art_no := TCad.GetCustArtNr(in_custaknr => cust_art_no, in_adkrz => in_adkrz);
              CASE
                 WHEN in_adkrz = 'AQUILA'
                 THEN
                      ata_chapter := SUBSTRING(cust_art_no from 6 for 4); -- bsp. AT02-2000-001_01P
                 ELSE
                      SELECT LEFT(ak_ordk,2) INTO ata_chapter FROM art WHERE ak_nr = in_ak_nr;
              END CASE;
              -- get file path
              file_path := (SELECT TRecnoParam.GetText('Cust.fnpath', adk.dbrid)
                           FROM adk
                           WHERE ad_krz = in_adkrz);

              -- Replace wild cards
              file_path := replace(file_path, '[pathwc1]', COALESCE(TCad.GetPathPart(in_dtid => in_pd_doktype, in_group => 1, in_adkrz => in_adkrz),'')); -- Wildcard 1 abhängig von Dateityp
              file_path := replace(file_path, '[pathwc2]', COALESCE(TCad.GetPathPart(in_dtid => in_pd_doktype, in_group => 2, in_adkrz => in_adkrz),'')); -- Wildcard 2 abhängig von Dateityp
              file_path := replace(file_path, '[pathwc3]', COALESCE(TCad.GetPathPart(in_dtid => in_pd_doktype, in_group => 3, in_adkrz => in_adkrz),'')); -- Wildcard 3 abhängig von Dateityp
              file_path := replace(file_path, '[ATA_full]', COALESCE(TCad.GetPathPart(in_dtid => ata_chapter, in_group => 4, in_adkrz => in_adkrz),'')); -- Wildcard 4 abhängig vom gesamten ATA Code
              file_path := replace(file_path, '[ATA_cpt]', COALESCE(TCad.GetPathPart(in_dtid => LEFT(ata_chapter,2), in_group => 5, in_adkrz => in_adkrz),'')); -- Wildcard 5 abhängig von ATA Chapter (erste zwei Stellen)
              file_path := replace(file_path, '[custdesc]', COALESCE(cust_art_name,tcad.nx_ak_bez(in_ak_nr)));
              file_path := replace(file_path, '[custartnr]', cust_art_no);
              file_path := replace(file_path, '[rev]', cust_art_rev);

              -- Get file name
              file_name := TCad.GetCustFileName (in_ak_nr => in_ak_nr, in_pd_doktype => in_pd_doktype, in_fileext => in_fileext, in_adkrz => in_adkrz);

              -- Combine filepath and file name
              file_path := CONCAT(file_path, file_name);
              RETURN file_path;
           ELSE
              RETURN NULL;
      END CASE;
END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.GetCustArtRev(in_custaknr VARCHAR, in_adkrz VARCHAR(21))
  RETURNS VARCHAR AS $$
  DECLARE indexchar VARCHAR;
      dbrid VARCHAR;
          part INTEGER;
  BEGIN
    dbrid := (SELECT adk.dbrid
              FROM adk
              WHERE ad_krz = in_adkrz);

    CASE
    WHEN TRecnoParam.Exists('Cust.akindex', dbrid)
    THEN
        indexchar := TRecnoParam.GetVarchar('Cust.akindex', dbrid);
        CASE strpos(reverse(in_custaknr), indexchar)
        WHEN 0 THEN -- kein Indextrenner vorhanden
            RETURN '';
        WHEN 1 THEN -- Indextrenner ist letztes Zeichen. D.h. der Index ist eingerahmt vom Trenner, zB 123'A'.
            part:= 2;
        ELSE -- sonst Indexzeichen vor Index
            part:= 1;
        END CASE;

        -- Kundenspezifsche Sonderfälle
        IF in_adkrz = 'AQUILA' AND in_custaknr LIKE '1800%' THEN
            RETURN '';
        END IF;

        RETURN reverse(split_part(reverse(in_custaknr), indexchar, part));
    ELSE
       RETURN NULL;
    END CASE;
  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TCad.GetCustArtNr(
    in_custaknr VARCHAR,
    in_adkrz VARCHAR(21))
  RETURNS VARCHAR AS $$
  DECLARE aknr VARCHAR;
          dbrid VARCHAR;
          indexchar VARCHAR;
          posindexchar INTEGER;
  BEGIN
    dbrid := (SELECT adk.dbrid
          FROM adk
          WHERE ad_krz = in_adkrz);

    CASE
    WHEN TRecnoParam.Exists('Cust.akindex', dbrid) THEN
        indexchar := TRecnoParam.GetVarchar('Cust.akindex', dbrid);

        IF COALESCE(indexchar, '') = '' THEN RETURN in_custaknr; END IF;  -- Kein IndexChar definiert, dann raus.
        IF StrPos(in_custaknr, '%') > 0 THEN RETURN in_custaknr; END IF;  -- Wildcard für Suche in Artikel, dann raus.
        IF StrPos(in_custaknr, 'Ø') > 0 THEN RETURN in_custaknr; END IF;  -- Artikel mit Durchmesserzeichen (Material), dann raus.

        posindexchar:= StrPos(reverse(in_custaknr), indexchar);

        IF (posindexchar = 0) OR (posindexchar > 4) THEN RETURN in_custaknr; END IF; -- Kein Index in Artikelnummer, dann raus.

        IF posindexchar = 1 THEN -- Indextrenner ist letztes Zeichen, dass heißt der Index ist eingerahmt vom Trenner, z.B. 123'A'.
            posindexchar:= StrPos(reverse(SubStr(in_custaknr, 1, Length(in_custaknr)-1)), indexchar) + 1;
        END IF;

        aknr:= SubStr(in_custaknr, 1, IFTHEN(in_custaknr LIKE '%' || indexchar || '%', Length(in_custaknr) - posindexchar, 100)::INTEGER);

        aknr:= rtrim(aknr); -- störende Leerzeichen rechts entfernen.

        -- Kundenspezifsche Sonderfälle
        IF in_adkrz = 'AQUILA' AND in_custaknr LIKE '1800%' THEN
            RETURN in_custaknr;
        END IF;

        RETURN aknr;
    ELSE
        RETURN in_custaknr;
    END CASE;
  END $$ LANGUAGE plpgsql;
